function polynomialEvaluatorUsingVectors
  /* Coefficients a,b,c in PolynomialEvaluator replaced by a vector a[3] */
  input Real x;
  output Real fx;
protected
  parameter Real a[3] = {1, 2, 1};
algorithm
  //fx := a[1] * x ^ 2 + a[2] * x + a[3];//
  fx := 0;
  for i in 1:3 loop
    fx := fx + a[i] * x ^ (3 - i);
  end for;
  /* At the end of loop, fx is equivalent to f(x) = a[1]*x^2 + a[2]*x  + a[3] */
end polynomialEvaluatorUsingVectors;